
#include <stdio.h>

int main(void) {
    // パラメータ
    const double a = 9.8;      // 加速度 [m/s^2]
    const double t_start = 0.0;
    const double t_end   = 2.0;
    const double dt      = 0.1;

    // t=0 から t=2 まで 0.1[s]刻みで t と x(t) を表示（空白区切り）
    for (int n = 0;; ++n) {
        double t = t_start + n * dt;
        if (t > t_end + 1e-12) break;          // 浮動小数誤差に対する安全な終了条件

        // 厳密解：x(t) = (1/2) a t^2 （x0=0, v0=0）
        double x = 0.5 * a * t * t;

               printf("%.6f %.12f\n", t, x);

        if (t >= t_end - 1e-12) break;
    }
    return 0;
