#include <stdio.h>
#include <math.h>

// 物理定数と時間設定
#define G_ACCELERATION 9.8    // 加速度 a [m/s^2]
#define T_START 0.0           // 開始時間 t_start [s]
#define T_END 2.0             // 終了時間 t_end [s]
#define DT 0.1                // 時間刻み幅 dt [s]

int main(void) {
    // 初期条件 (厳密解では初期値は式に組み込まれていますが、念のため定義)
    double a = G_ACCELERATION;
    
    // 時間tを初期化
    double t = T_START;     
    
    // 厳密解の係数 (1/2 * a)
    const double COEFFICIENT = 0.5 * a;

    printf("--- 運動方程式の厳密解 (解析解) ---\n");
    printf("解の式: x(t) = 0.5 * %.1f * t^2\n", a);
    printf("------------------------------------------\n");
    printf("   t [s]   |   x [m] (厳密解)\n");
    printf("-----------|------------------\n");

    // T_END (2.0秒)まで DT (0.1秒) 刻みで計算と表示を継続
    // 浮動小数点数の比較誤差を考慮し、微小な値を加算
    while (t <= T_END + 1e-9) {
        
        // 厳密解の計算: x = (1/2) * a * t^2
        double x = COEFFICIENT * t * t;
        
        // t と x を表示
        printf("  %8.2f |  %15.8f\n", t, x);

        // 時間を進行
        t = t + DT;
    }

    printf("------------------------------------------\n");
    
    return 0;
}